/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.eventmon;

import com.ibm.hwmca.fw.eventmon.DelayQueueListener;
import com.ibm.hwmca.fw.eventmon.DelayQueueTester;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DelayQueue {
    private int _delaySecs;
    private List _workList = new LinkedList();
    private Thread _alarmClock;
    private Set _listeners = new HashSet();
    private String _name;

    public static void main(String[] args) {
        DelayQueue _queue = new DelayQueue(10, "testing123");
        _queue.addListener(new DelayQueueTester());
        int i = 0;
        while (i < 30) {
            _queue.push(new Integer(i));
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            ++i;
        }
    }

    public DelayQueue(int delaySecs, String name) {
        this._delaySecs = delaySecs;
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public int getDelay() {
        return this._delaySecs;
    }

    public synchronized boolean isExpired() {
        return this._workList.isEmpty() && this._alarmClock == null;
    }

    public synchronized void push(Object work) {
        this._workList.add(work);
        if (this._alarmClock == null) {
            this.fireEvent();
        }
    }

    public synchronized void addListener(DelayQueueListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeListener(DelayQueueListener listener) {
        this._listeners.remove(listener);
    }

    public synchronized void fireEvent() {
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            DelayQueueListener listener = (DelayQueueListener)listeners.next();
            listener.handleWorkList((List)((LinkedList)this._workList).clone(), this);
        }
        if (this._workList.isEmpty()) {
            this._alarmClock = null;
        } else {
            this._workList.clear();
            this._alarmClock = new Thread(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(DelayQueue.this._delaySecs * 1000);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    DelayQueue.this.fireEvent();
                }
            };
            this._alarmClock.start();
        }
    }
}

